var DirectMail = DirectMail || {};

DirectMail.refreshChartWithIdentifier = function(identifier) {
	var chart     = $('#' + identifier);
	var chartType = chart.attr('data-chart-type');
		
	$('svg', chart).remove();
	
	if (chartType == 'pie') {
		this.refreshPieChartWithIdentifier(identifier);
	}
	else if (chartType == 'bar') {
		this.refreshBarChartWithIdentifier(identifier);
	}
	else if (chartType == 'line') {
		this.refreshLineChartWithIdentifier(identifier);
	}
};

DirectMail.refreshPieChartWithIdentifier = function(identifier) {
	var chart = $('#' + identifier);

	(function (raphael) {
	    $(function () {	
			var historyChart = window.DirectMail_deliveryHistoryChartManager.chartWithIdentifier( identifier );
			var seriess 	 = historyChart.seriess;
			var colors		 = historyChart.colors;
			var chartW		 = chart.innerWidth();
			var chartH		 = chart.innerHeight();
			var s			 = Math.min(chartW, chartH);
			var center		 = Math.floor(s/2);

		    raphael(identifier, chartW, chartH).pieChart(
				Math.floor(chartW/2), 
				Math.floor(chartH/2), 
				Math.floor(s/2 * 0.70), 
				seriess, 
				colors, 
				'white', 
				historyChart.labelDisplayMode(),
				historyChart.isClickable() ? function (event, series, label) {
					historyChart.didClickLabelInSeries(label, series);
				} : null,
				function (event, series, label) {
					historyChart.didMouseOverLabelInSeries(label, series);
				},
				function (event, series, label) {
					historyChart.didMouseOutLabelInSeries(label, series);
				},
				historyChart.noDataNotice()
			);
	    });
	})(Raphael);
};

DirectMail.refreshLineChartWithIdentifier = function(identifier) {
	var chart = $('#' + identifier);
	
	(function (raphael) {
	    $(function () {	
			var historyChart = window.DirectMail_deliveryHistoryChartManager.chartWithIdentifier( identifier );
			var seriess 	 = historyChart.seriess;
			var masterLabels = historyChart.masterLabels;
			var colors		 = historyChart.colors;
			var sizingChart  = raphael(0, 0, 0, 0);
			var metrics      = sizingChart.lineChartMetrics(seriess, masterLabels);
			var chartW	     = metrics.chartElementWidth;
			
			$(chart).width(chartW);
			sizingChart.remove();
			
			var chartH = chart.innerHeight();
			
			raphael(identifier, chartW, chartH).lineChart(
				metrics,
				chartH,
				seriess, 
				masterLabels,
				colors,
				function (event, series, label) {
					historyChart.didMouseOverLabelInSeries(label, series);
				},
				function (event, series, label) {
					historyChart.didMouseOutLabelInSeries(label, series);
				}
			);
	    });
	})(Raphael);
};

DirectMail.refreshBarChartWithIdentifier = function(identifier) {
	var chart = $('#' + identifier);
	
	(function (raphael) {
	    $(function () {	
			var historyChart = window.DirectMail_deliveryHistoryChartManager.chartWithIdentifier( identifier );
			var seriess 	 = historyChart.seriess;
			var masterLabels = historyChart.masterLabels;
			var colors		 = historyChart.colors;
			var sizingChart  = raphael(0, 0, 0, 0);
			var metrics      = sizingChart.barChartMetrics(seriess, masterLabels);
			var chartW	     = metrics.chartElementWidth;
			
			$(chart).width(chartW);
			sizingChart.remove();
			
			var chartH = chart.innerHeight();
			
			raphael(identifier, chartW, chartH).barChart(
				metrics,
				chartH,
				seriess, 
				masterLabels,
				colors,
				historyChart.isClickable() ? function (event, series, label) {
					historyChart.didClickLabelInSeries(label, series);
				} : null,
				function (event, series, label) {
					historyChart.didMouseOverLabelInSeries(label, series);
				},
				function (event, series, label) {
					historyChart.didMouseOutLabelInSeries(label, series);
				}
			);
	    });
	})(Raphael);
};

DirectMail.hsbaFromColor = function(color) {
	return {
		h: color.hueComponent(),
		s: color.saturationComponent(),
		b: color.brightnessComponent(),
		a: color.alphaComponent()
	};
};

DirectMail.hsbaDeclarationWithValues = function(hsba) {
	return "hsba(" + hsba.h + "," + hsba.s + "," + hsba.b + "," + hsba.a + ")";
};

$(document).ready(function() {
	$(window).resize(function() {
		$('.fill-parent-chart').each(function(index) {
			DirectMail.refreshChartWithIdentifier($(this).attr('id'));
		});
	});
});
